//
//  MCSectionHeader.h
//  MCApplication
//
//  Created by Ali Lalani on 1/25/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MCSectionHeader : NSView {
	NSColor *topBorderColor;
	NSColor *bottomBorderColor;
	
	NSString              *sectionTitle;	
	NSMutableDictionary   *sectionTitleAttributes;

	NSString              *secondaryTitle;
	NSMutableDictionary   *secondaryTitleAttributes;

	float leftTextMargin;
	float rightTextMargin;
	float secondaryTextMargin;

	BOOL hasVerticalSplitControl;
	BOOL hasHorizontalSplitControl;

	NSRect _verticalSplitControlRect;
	NSTrackingRectTag _verticalSplitControlTrackingRectTag;
	
	NSRect _horizontalSplitControlRect;
	NSTrackingRectTag _horizontalSplitControlTrackingRectTag;

	BOOL hasTopBorder;
	BOOL hasBottomBorder;
}


- (NSRect)calculatedVerticalSplitControlHitRect;
- (NSRect)calculatedHorizontalSplitControlHitRect;

#pragma mark Accessors
- (NSColor *)topBorderColor;
- (void)setTopBorderColor:(NSColor *)aTopBorderColor;
- (NSColor *)bottomBorderColor;
- (void)setBottomBorderColor:(NSColor *)aBottomBorderColor;

- (NSString *)sectionTitle;
- (void)setSectionTitle:(NSString *)aSectionTitle;
- (NSMutableDictionary *)sectionTitleAttributes;
- (void)setSectionTitleAttributes:(NSMutableDictionary *)aSectionTitleAttributes;

- (NSString *)secondaryTitle;
- (void)setSecondaryTitle:(NSString *)aSecondaryTitle;
- (NSMutableDictionary *)secondaryTitleAttributes;
- (void)setSecondaryTitleAttributes:(NSMutableDictionary *)aSecondaryTitleAttributes;

- (float)leftTextMargin;
- (void)setLeftTextMargin:(float)aLeftTextMargin;
- (float)rightTextMargin;
- (void)setRightTextMargin:(float)aRightTextMargin;
- (float)secondaryTextMargin;
- (void)setSecondaryTextMargin:(float)aSecondaryTextMargin;

- (BOOL)hasVerticalSplitControl;
- (void)setHasVerticalSplitControl:(BOOL)flag;
- (BOOL)hasHorizontalSplitControl;
- (void)setHasHorizontalSplitControl:(BOOL)flag;

- (BOOL)hasTopBorder;
- (void)setHasTopBorder:(BOOL)flag;
- (BOOL)hasBottomBorder;
- (void)setHasBottomBorder:(BOOL)flag;

@end
